/*
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#pragma once

#ifdef __cplusplus

#include "BPlatform.h"

#if !BUSE(TZONE)

#include "FreeList.h"

#if !BUSE(LIBPAS)

namespace bmalloc {

template<typename Config> class IsoPage;
template<typename Config> class IsoHeapImpl;

enum class AllocationMode : uint8_t { Init, Fast, Shared };

template<typename Config>
class IsoAllocator {
public:
    IsoAllocator(IsoHeapImpl<Config>&);
    ~IsoAllocator();
    
    void* allocate(IsoHeapImpl<Config>&, bool abortOnFailure);
    void scavenge(IsoHeapImpl<Config>&);
    
private:
    void* allocateSlow(IsoHeapImpl<Config>&, bool abortOnFailure);
    
    FreeList m_freeList;
    IsoPage<Config>* m_currentPage { nullptr };
};

} // namespace bmalloc

#endif
#endif // !BUSE(TZONE)

#endif // __cplusplus
